
##############################
# Country definition for FRA #
##############################

province =
{ id         = 32
  ic         = 3
  anti_air   = 4
  air_base   = { size = 10 current_size = 10 }
  naval_base = { size = 10 current_size = 10 }
}              # Brest
province = { id = 34 ic = 3 } # Lorient
province = { id = 35 anti_air = 2 } # Nantes
province =
{ id         = 38
  anti_air   = 3
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 6 current_size = 6 }
}              # Cherbourg
province = { id = 39 anti_air = 1 } # Caen
province =
{ id         = 43
  naval_base = { size = 3 current_size = 3 }
}              # Dunkerque
province =
{ id       = 44
  air_base = { size = 10 current_size = 10 }
  anti_air = 1
}            # Lille
province =
{ id       = 56
  ic       = 5
  anti_air = 5
  air_base = { size = 10 current_size = 10 }
}            # Paris
province = { id = 58 ic = 1 } # Le Mans
province =
{ id       = 59
  ic       = 1
  air_base = { size = 10 current_size = 10 }
}            # Cholet
province =
{ id       = 62
  ic       = 2
  air_base = { size = 10 current_size = 10 }
}            # Auxerre
province =
{ id       = 72
  anti_air = 3
  air_base = { size = 10 current_size = 10 }
  landfort = 10
}            # Metz
province = { id = 73 anti_air = 2 landfort = 10 } # Strasbourg
province = { id = 316 ic = 1 anti_air = 2 landfort = 10 } # Mulhouse
province = { id = 317 anti_air = 1 } # Chaumont
province = { id = 320 ic = 4 anti_air = 1 } # Vichy
province =
{ id         = 325
  anti_air   = 4
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 6 current_size = 6 }
}              # Bordeaux
province =
{ id       = 359
  air_base = { size = 10 current_size = 10 }
}            # Toulouse
province =
{ id         = 364
  ic         = 5
  anti_air   = 5
  air_base   = { size = 10 current_size = 10 }
  naval_base = { size = 10 current_size = 10 }
}              # Marseille
province = { id = 366 landfort = 5 } # Nice
province = { id = 527 landfort = 3 } # Grenoble
province =
{ id       = 528
  ic       = 5
  air_base = { size = 10 current_size = 10 }
}            # Lyon
province = { id = 875 supplypool = 1 } # Cayenne
province =
{ id         = 939
  anti_air   = 4
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 5 current_size = 5 }
}              # Tunis
province =
{ id         = 949
  supplypool = 500
  oilpool    = 1
  anti_air   = 4
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 5 current_size = 5 }
}              # Algiers
province =
{ id         = 953
  anti_air   = 2
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 2 current_size = 2 }
}              # Oran
province =
{ id         = 958
  anti_air   = 3
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 4 current_size = 4 }
}              # Casablanca
province =
{ id         = 981
  anti_air   = 3
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 2 current_size = 2 }
}              # Dakar
province =
{ id       = 993
  anti_air = 2
  air_base = { size = 4 current_size = 4 }
}            # Abidjan
province = { id = 1037 supplypool = 1 } # Djibouti
province =
{ id         = 1328
  anti_air   = 4
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 4 current_size = 4 }
}              # Hanoi
province =
{ id         = 1337
  supplypool = 100
  oilpool    = 1
  anti_air   = 3
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 4 current_size = 4 }
}              # Saigon
province =
{ id         = 1794
  anti_air   = 2
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 2 current_size = 2 }
}              # Beirut

#####################
# Country main data #
#####################

country =
{ tag                    = FRA
  capital                = 56
  # Resource Reserves
  energy                 = 1000
  metal                  = 1000
  rare_materials         = 500
  oil                    = 500
  supplies               = 500
  money                  = 100
  manpower               = 425
  transports             = 350
  escorts                = 60
  policy =
  { date              = { year = 0 month = january day = 0 }
    democratic        = 10
    political_left    = 6
    free_market       = 8
    freedom           = 10
    professional_army = 3
    defense_lobby     = 7
    interventionism   = 8
  }
  SpyInfo                = { country = "FRA" NumberOfSpies = 9 }
  #SpyInfo                = { country = "ENG" NumberOfSpies = 8 }
  #SpyInfo                = { country = "GER" NumberOfSpies = 10 }
  #SpyInfo                = { country = "SOV" NumberOfSpies = 5 }
  #SpyInfo                = { country = "CZE" NumberOfSpies = 4 }
  #SpyInfo                = { country = "AUS" NumberOfSpies = 4 }
  #SpyInfo                = { country = "SPA" NumberOfSpies = 5 }
  #SpyInfo                = { country = "POL" NumberOfSpies = 5 }
  #SpyInfo                = { country = "SWE" NumberOfSpies = 8 }
  #SpyInfo                = { country = "NOR" NumberOfSpies = 4 }
  #SpyInfo                = { country = "FIN" NumberOfSpies = 4 }
  #SpyInfo                = { country = "YUG" NumberOfSpies = 4 }
  #SpyInfo                = { country = "HUN" NumberOfSpies = 5 }
  #SpyInfo                = { country = "BUL" NumberOfSpies = 4 }
  #SpyInfo                = { country = "BEL" NumberOfSpies = 10 }
  #SpyInfo                = { country = "DEN" NumberOfSpies = 5 }
  #SpyInfo                = { country = "HOL" NumberOfSpies = 8 }
  #SpyInfo                = { country = "ARG" NumberOfSpies = 5 }
  #SpyInfo                = { country = "USA" NumberOfSpies = 5 }
  #SpyInfo                = { country = "ALB" NumberOfSpies = 4 }
  #SpyInfo                = { country = "GRE" NumberOfSpies = 4 }
  #SpyInfo                = { country = "JAP" NumberOfSpies = 5 }
  #SpyInfo                = { country = "ROM" NumberOfSpies = 4 }
  #SpyInfo                = { country = "LUX" NumberOfSpies = 5 }
  #SpyInfo                = { country = "POR" NumberOfSpies = 4 }
  #SpyInfo                = { country = "ITA" NumberOfSpies = 10 }
  # Metropolitan France
  nationalprovinces      = { 529 527 366 365 367 364 363 362 358 328 327 326 325 324 359 361 319 360 322 323 59  60  61  62  63  318 317 316 73  72 
                             64  53  44  43  18  54  42  55  41  56  57  58  32  33  34  35  36  37  38  39  40  320 321 528
                           }
  # Metropolitan France
  ownedprovinces         = { 529  527  366  365  367  364  363  362  358  328  327  326  325  324  359  361  319  360  322  323  59   60   61   62  
                             63   318  317  316  73   72   64   53   44   43   18   54   42   55   41   56   57   58   32   33   34   35   36   37  
                             38   39   40   320  321  528  875  898  899  956  969  968  959  958  960  966  1014 970  1013 943  942  945  944  946 
                             947  949  948  951  950  952  953  935  934  936  938  937  939  940  941  1862 1861 1863 1792 1793 1794 1795 1037 973 
                             974  975  1083 1084 998  976  977  978  981  984  987  989  990  985  980  986  979  994  996  997  1005 1006 991  995 
                             993  1088 1003 1004 1082 1081 1080 1079 1086 1070 1078 1077 1087 1089 1092 1093 1075 1076 1134 1137 1135 1338 1339 1340
                             1337 1335 1336 1334 1333 1332 1329 1328 1306 1326 1341 1692 1691 1687 1690 1689 1688 1682 1751
                           }
  # Metropolitan France
  controlledprovinces    = { 529  527  366  365  367  364  363  362  358  328  327  326  325  324  359  361  319  360  322  323  59   60   61   62  
                             63   318  317  316  73   72   64   53   44   43   18   54   42   55   41   56   57   58   32   33   34   35   36   37  
                             38   39   40   320  321  528  875  898  899  956  969  968  959  958  960  966  1014 970  1013 943  942  945  944  946 
                             947  949  948  951  950  952  953  935  934  936  938  937  939  940  941  1862 1861 1863 1792 1793 1794 1795 1037 973 
                             974  975  1083 1084 998  976  977  978  981  984  987  989  990  985  980  986  979  994  996  997  1005 1006 991  995 
                             993  1088 1003 1004 1082 1081 1080 1079 1086 1070 1078 1077 1087 1089 1092 1093 1075 1076 1134 1137 1135 1338 1339 1340
                             1337 1335 1336 1334 1333 1332 1329 1328 1306 1326 1341 1692 1691 1687 1690 1689 1688 1682 1751
                           }
  # FRA 1939 techs
  # ######################
  techapps               = { 4060  4170  4190  4010  4020  4030  4040  4050  4120  4130  4140  2150  2160  2010  2020  2040  2030  2050  2070 
                             2100  2290  2300  2310  2320  2330  2400  2450  2460  2510  1010  1020  1190  1200  1210  1220  1030  1230  1110  1120 
                             5010  5020  5030  5050  5060  5070  5080  5090  5100  5110  5190  5200  5210  5310  5320  5470  5480  9010  9020  9030 
                             9040  9050  9060  6010  6030  6110  6120  8010  8020  8030  8040  8050  8070  8100  8120  3010  3020  3030  3040  3070 
                             3080  3090  3100  3130  3140  3150  3190  3200  3210  3220  3250  3260  3270  3280  3320  3330  3340  3400  3410  3420 
                             14000 14010 1310  1340
                           }
  diplomacy =
  { relation = { tag = AST value = 150 }
    relation =
    { tag        = BEL
      value      = 120
      guaranteed = { day = 30 month = december year = 1935 }
    }
    relation = { tag = BHU value = 150 }
    relation = { tag = BUL value = 20 }
    relation = { tag = CAN value = 150 }
    relation = { tag = EST value = 65 }
    relation = { tag = SLO value = -200 }
    relation = { tag = DEN value = 75 }
    relation = { tag = ENG value = 150 }
    relation = { tag = FIN value = 85 }
    relation = { tag = GER value = -200 }
    relation =
    { tag        = GRE
      value      = 75
      guaranteed = { day = 13 month = april year = 1939 }
    }
    relation = { tag = HOL value = 75 }
    relation = { tag = HUN value = -70 }
    relation = { tag = IRQ value = 100 }
    relation = { tag = ITA value = -100 }
    relation = { tag = JAP value = -40 }
    relation = { tag = LAT value = 65 }
    relation = { tag = LIT value = 65 }
    relation = { tag = LUX value = 120 }
    relation = { tag = NEP value = 150 }
    relation = { tag = NOR value = 100 }
    relation = { tag = NZL value = 150 }
    relation = { tag = OMN value = 150 }
    relation =
    { tag        = POL
      value      = 200
      guaranteed = { day = 30 month = march year = 1939 }
    }
    relation =
    { tag        = ROM
      value      = 50
      guaranteed = { day = 13 month = april year = 1939 }
    }
    relation = { tag = SAF value = 150 }
    relation = { tag = SCH value = 1 }
    relation = { tag = SIA value = -100 }
    relation = { tag = SOV value = 100 }
    relation = { tag = SPA value = -65 }
    relation = { tag = SWE value = 80 }
    relation =
    { tag        = TUR
      value      = 50
      guaranteed = { day = 23 month = june year = 1939 }
    }
    relation = { tag = USA value = 65 }
    relation = { tag = YEM value = 150 }
    relation = { tag = YUG value = 50 }
  }
  headofstate            = { type = 9 id = 2001 }
  headofgovernment       = { type = 9 id = 2037 }
  foreignminister        = { type = 9 id = 2054 }
  armamentminister       = { type = 9 id = 2076 }
  ministerofsecurity     = { type = 9 id = 2107 }
  ministerofintelligence = { type = 9 id = 2128 }
  chiefofstaff           = { type = 9 id = 2007 }
  chiefofarmy            = { type = 9 id = 2008 }
  chiefofnavy            = { type = 9 id = 2009 }
  chiefofair             = { type = 9 id = 2010 }
  dormant_ministers      = { 2002 2033 2036 2003 2049 2053 2004 2091 2005 2117 2006 }
  # #################
  # ###FRENCH OOB####
  # #################
  landunit =
  { id       = { type = 10527 id = 193 }
    name     = "1ž "
    location = 53
    division =
    { id       = { type = 10527 id = 194 }
      name     = "1ž˾ "
      strength = 100
      type     = hq
    }
  }
  landunit =
  { id       = { type = 10527 id = 195 }
    name     = "2ž "
    location = 72
    division =
    { id       = { type = 10527 id = 196 }
      name     = "2ž˾ "
      strength = 100
      type     = hq
    }
  }
  landunit =
  { id       = { type = 10527 id = 197 }
    name     = "3ž "
    location = 316
    division =
    { id       = { type = 10527 id = 198 }
      name     = "3ž˾ "
      strength = 100
      type     = hq
    }
  }
  landunit =
  { id       = { type = 10527 id = 1 }
    name     = "7ž "
    location = 64
    division =
    { id       = { type = 10527 id = 2 }
      name     = "4ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 3 }
      name     = "21ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 4 }
      name     = "60ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 5 }
      name     = "11װʦ "
      strength = 70
      type     = armor
      model    = 2
    }
    division =
    { id       = { type = 10527 id = 6 }
      name     = "25Ħлʦ "
      strength = 70
      type     = motorized
    }
    division =
    { id       = { type = 10527 id = 7 }
      name     = "4Ħлʦ "
      strength = 70
      type     = motorized
    }
  }
  # #######################
  landunit =
  { id       = { type = 10527 id = 8 }
    name     = "1ž "
    location = 317
    division =
    { id       = { type = 10527 id = 9 }
      name     = "1װʦ "
      strength = 70
      type     = armor
      model    = 2
    }
    division =
    { id       = { type = 10527 id = 10 }
      name     = "32ʦ "
      strength = 70
      type     = infantry
      extra    = anti_tank
    }
    division =
    { id       = { type = 10527 id = 11 }
      name     = "2װʦ "
      strength = 70
      type     = armor
      model    = 2
    }
    division =
    { id       = { type = 10527 id = 12 }
      name     = "3װʦ "
      strength = 70
      type     = armor
      model    = 2
    }
    division =
    { id       = { type = 10527 id = 13 }
      name     = "1Ħлʦ "
      strength = 70
      type     = motorized
    }
    division =
    { id       = { type = 10527 id = 14 }
      name     = "2''ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 15 }
      name     = "15Ħлʦ "
      strength = 70
      type     = motorized
    }
    division =
    { id       = { type = 10527 id = 199 }
      name     = "1ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 16 }
      name     = "12Ħлʦ "
      strength = 70
      type     = motorized
    }
    division =
    { id       = { type = 10527 id = 17 }
      name     = "5''ʦ "
      strength = 70
      type     = infantry
      extra    = anti_tank
    }
  }
  # ####################
  # ####################
  landunit =
  { id       = { type = 10527 id = 18 }
    name     = "9ž "
    location = 316
    division =
    { id       = { type = 10527 id = 19 }
      name     = "1ʦ "
      strength = 70
      type     = cavalry
    }
    division =
    { id       = { type = 10527 id = 20 }
      name     = "4ʦ "
      strength = 70
      type     = cavalry
    }
    division =
    { id       = { type = 10527 id = 21 }
      name     = "4''ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 22 }
      name     = "53ʦ "
      strength = 70
      type     = infantry
      extra    = anti_tank
    }
    division =
    { id       = { type = 10527 id = 23 }
      name     = "5Ħлʦ "
      strength = 70
      type     = motorized
    }
    division =
    { id       = { type = 10527 id = 24 }
      name     = "18ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 25 }
      name     = "22ʦ "
      strength = 70
      type     = infantry
    }
  }
  # ###########################
  landunit =
  { id       = { type = 10527 id = 26 }
    name     = "2ž "
    location = 73
    division =
    { id       = { type = 10527 id = 27 }
      name     = "2ʦ "
      strength = 70
      type     = cavalry
    }
    division =
    { id       = { type = 10527 id = 28 }
      name     = "5ʦ "
      strength = 70
      type     = cavalry
    }
    division =
    { id       = { type = 10527 id = 29 }
      name     = "71ʦ "
      strength = 70
      type     = infantry
      extra    = anti_tank
    }
    division =
    { id       = { type = 10527 id = 30 }
      name     = "3''ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 31 }
      name     = "55ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 32 }
      name     = "1ֳزʦ "
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 33 }
      name     = "3ֳزʦ "
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 34 }
      name     = "41ֳزʦ "
      strength = 70
      type     = infantry
    }
  }
  # ##################
  # ##################
  landunit =
  { id       = { type = 10527 id = 35 }
    name     = "3ž "
    location = 72
    division =
    { id       = { type = 10527 id = 36 }
      name     = "3ʦ "
      strength = 75
      type     = cavalry
    }
    division =
    { id       = { type = 10527 id = 37 }
      name     = "6ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 38 }
      name     = "7ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 39 }
      name     = "8ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 40 }
      name     = "6ֳزʦ "
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 41 }
      name     = "6''ʦ "
      strength = 70
      type     = infantry
      extra    = anti_tank
    }
    division =
    { id       = { type = 10527 id = 42 }
      name     = "2ʦ "
      strength = 70
      type     = infantry
      extra    = anti_tank
    }
    division =
    { id       = { type = 10527 id = 43 }
      name     = "56ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 44 }
      name     = "26ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 45 }
      name     = "42ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 46 }
      name     = "51ʦ "
      strength = 70
      type     = infantry
      extra    = anti_tank
    }
    division =
    { id       = { type = 10527 id = 47 }
      name     = "20ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 48 }
      name     = "58ʦ "
      strength = 55
      type     = infantry
    }
  }
  # ######################
  # #######################
  landunit =
  { id       = { type = 10527 id = 49 }
    name     = "4ž "
    location = 53
    division =
    { id       = { type = 10527 id = 50 }
      name     = "45ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 51 }
      name     = "11ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 52 }
      name     = "47ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 53 }
      name     = "52ʦ "
      strength = 70
      type     = infantry
      extra    = anti_tank
    }
    division =
    { id       = { type = 10527 id = 54 }
      name     = "58''ʦ "
      strength = 70
      type     = infantry
    }
  }
  # #####################
  landunit =
  { id       = { type = 10527 id = 55 }
    name     = "5ž "
    location = 63
    division =
    { id       = { type = 10527 id = 56 }
      name     = "44ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 57 }
      name     = "24ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 58 }
      name     = "31ʦ "
      strength = 60
      type     = bergsjaeger
    }
    division =
    { id       = { type = 10527 id = 59 }
      name     = "16ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 60 }
      name     = "35ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 61 }
      name     = "70ʦ "
      strength = 70
      type     = infantry
      extra    = anti_tank
    }
    division =
    { id       = { type = 10527 id = 62 }
      name     = "62ʦ "
      strength = 70
      type     = infantry
      extra    = anti_tank
    }
    division =
    { id       = { type = 10527 id = 63 }
      name     = "30ʦ "
      strength = 60
      type     = bergsjaeger
    }
  }
  # #########################
  landunit =
  { id       = { type = 10527 id = 64 }
    name     = "8ž "
    location = 366
    division =
    { id       = { type = 10527 id = 65 }
      name     = "13ʦ "
      strength = 70
      type     = infantry
      extra    = anti_tank
    }
    division =
    { id       = { type = 10527 id = 66 }
      name     = "27ʦ "
      strength = 60
      type     = bergsjaeger
    }
    division =
    { id       = { type = 10527 id = 67 }
      name     = "19ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 68 }
      name     = "54ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 69 }
      name     = "67ʦ "
      strength = 70
      type     = infantry
    }
  }
  # #############################
  landunit =
  { id       = { type = 10527 id = 70 }
    name     = "˹ "
    location = 527
    division =
    { id       = { type = 10527 id = 71 }
      name     = "8ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 72 }
      name     = "64ʦ "
      strength = 60
      type     = bergsjaeger
    }
    division =
    { id       = { type = 10527 id = 73 }
      name     = "66ʦ "
      strength = 60
      type     = bergsjaeger
    }
    division =
    { id       = { type = 10527 id = 74 }
      name     = "2ֳزʦ "
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 75 }
      name     = "65ʦ "
      strength = 60
      type     = bergsjaeger
    }
  }
  # #######################
  landunit =
  { id       = { type = 10527 id = 76 }
    name     = "19ž "
    location = 949
    division =
    { id       = { type = 10527 id = 77 }
      name     = "85''ʦ "
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 78 }
      name     = "181''ʦ "
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 79 }
      name     = "182''ʦ "
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 80 }
      name     = "183''ʦ "
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 81 }
      name     = "ǰ "
      strength = 40
      type     = infantry
    }
  }
  # ##########################
  landunit =
  { id       = { type = 10527 id = 82 }
    name     = "ͻ˹ "
    location = 939
    division =
    { id       = { type = 10527 id = 83 }
      name     = "83''ʦ "
      strength = 60
      type     = infantry
      extra    = anti_tank
    }
    division =
    { id       = { type = 10527 id = 84 }
      name     = "84''ʦ "
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 85 }
      name     = "88''ʦ "
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 86 }
      name     = "81''ʦ "
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 87 }
      name     = "180''ʦ "
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 88 }
      name     = "6ʦ "
      strength = 65
      type     = cavalry
    }
  }
  # #########################
  landunit =
  { id       = { type = 10527 id = 89 }
    name     = "Ħ "
    location = 958
    division =
    { id       = { type = 10527 id = 90 }
      name     = "3Ħʦ "
      strength = 60
      type     = infantry
      extra    = anti_tank
    }
  }
  # ############################
  landunit =
  { id       = { type = 10527 id = 91 }
    name     = "ӡ֧Ǿ "
    location = 1337
    division =
    { id       = { type = 10527 id = 92 }
      name     = "ʦ "
      strength = 65
      type     = infantry
    }
    division =
    { id       = { type = 10527 id = 93 }
      name     = "-կʦ "
      strength = 60
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 10527 id = 94 }
    name     = "Զ "
    location = 364
    division =
    { experience = 25
      id         = { type = 10527 id = 95 }
      name       = "1װʦ "
      strength   = 60
      type       = infantry
    }
    division =
    { experience = 25
      id         = { type = 10527 id = 96 }
      name       = "1Աʦ "
      strength   = 60
      type       = bergsjaeger
    }
    division =
    { experience = 25
      id         = { type = 10527 id = 97 }
      name       = "2Աʦ "
      strength   = 60
      type       = bergsjaeger
    }
  }
  # ##########################
  navalunit =
  { id       = { type = 10527 id = 98 }
    name     = "1 "
    location = 32
    base     = 32
    division =
    { id    = { type = 10527 id = 180 }
      name  = "ؿ̶˺ "
      type  = battlecruiser
      model = 3
    }
    division =
    { id            = { type = 10527 id = 99 }
      name          = "Ƕ "
      type          = carrier
      model         = 1
      extra         = cag
      brigade_model = 2
    }
    division =
    { id    = { type = 10527 id = 100 }
      name  = "ëغ "
      type  = light_cruiser
      model = 1
    }
    division =
    { id    = { type = 10527 id = 101 }
      name  = "ϸǡ³ "
      type  = light_cruiser
      model = 1
    }
    division =
    { id    = { type = 10527 id = 102 }
      name  = "ĪءƤǺ "
      type  = light_cruiser
      model = 1
    }
    division =
    { id    = { type = 10527 id = 103 }
      name  = "ᰣ "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 10527 id = 105 }
      name  = "1֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 10527 id = 106 }
      name  = "2֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 10527 id = 113 }
      name  = "1佢֧ "
      type  = transport
      model = 0
    }
  }
  navalunit =
  { id       = { type = 10527 id = 104 }
    name     = "2 "
    location = 939
    base     = 939
    division =
    { id    = { type = 10527 id = 114 }
      name  = "˹˹ "
      type  = battlecruiser
      model = 3
    }
    division =
    { id    = { type = 10527 id = 107 }
      name  = "׺ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 10527 id = 108 }
      name  = "˹˹ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 10527 id = 181 }
      name  = "³ٺ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 10527 id = 109 }
      name  = "º "
      type  = light_cruiser
      model = 1
    }
    division =
    { id    = { type = 10527 id = 110 }
      name  = "3֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 10527 id = 111 }
      name  = "4֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 10527 id = 187 }
      name  = "5֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 10527 id = 117 }
      name  = "2佢֧ "
      type  = transport
      model = 0
    }
  }
  navalunit =
  { id       = { type = 10527 id = 112 }
    name     = "3 "
    location = 949
    base     = 949
    division =
    { id    = { type = 10527 id = 192 }
      name  = " "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 10527 id = 164 }
      name  = " "
      type  = heavy_cruiser
      model = 2
    }
    division =
    { id    = { type = 10527 id = 182 }
      name  = "á¡άɺ "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 10527 id = 183 }
      name  = " "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 10527 id = 184 }
      name  = "ٺ "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 10527 id = 185 }
      name  = "ɿķ "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 10527 id = 186 }
      name  = "Ρ "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 10527 id = 115 }
      name  = " "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 10527 id = 116 }
      name  = "ͼά "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 10527 id = 188 }
      name  = "6֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 10527 id = 118 }
      name  = "7֧ "
      type  = destroyer
      model = 2
    }
    division =
    { id    = { type = 10527 id = 119 }
      name  = "8֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 10527 id = 162 }
      name  = "3佢֧ "
      type  = transport
      model = 0
    }
  }
  navalunit =
  { id       = { type = 10527 id = 120 }
    name     = "4 "
    location = 364
    base     = 364
    division =
    { id    = { type = 10527 id = 121 }
      name  = "ֺ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 10527 id = 122 }
      name  = "˹ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 10527 id = 123 }
      name  = "غ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 10527 id = 124 }
      name  = "˹ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 10527 id = 125 }
      name  = "׶ "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 10527 id = 191 }
      name  = "9֧ "
      type  = destroyer
      model = 2
    }
    division =
    { id    = { type = 10527 id = 126 }
      name  = "10֧ "
      type  = destroyer
      model = 2
    }
    division =
    { id    = { type = 10527 id = 189 }
      name  = "11֧ "
      type  = destroyer
      model = 2
    }
    division =
    { id    = { type = 10527 id = 190 }
      name  = "12֧ "
      type  = destroyer
      model = 2
    }
    division =
    { id    = { type = 10527 id = 163 }
      name  = "4佢֧ "
      type  = transport
      model = 0
    }
  }
  navalunit =
  { id       = { type = 10527 id = 127 }
    name     = "1Ǳͧ "
    location = 364
    base     = 364
    division =
    { id    = { type = 10527 id = 128 }
      name  = "1Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10527 id = 129 }
      name  = "2Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10527 id = 165 }
      name  = "3Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 10527 id = 166 }
      name  = "4Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 10527 id = 167 }
      name  = "5Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
  }
  navalunit =
  { id       = { type = 10527 id = 130 }
    name     = "2Ǳͧ "
    location = 939
    base     = 939
    division =
    { id    = { type = 10527 id = 131 }
      name  = "6Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10527 id = 132 }
      name  = "7Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 10527 id = 168 }
      name  = "8Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10527 id = 169 }
      name  = "9Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10527 id = 170 }
      name  = "10Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
  }
  navalunit =
  { id       = { type = 10527 id = 133 }
    name     = "3Ǳͧ "
    location = 949
    base     = 949
    division =
    { id    = { type = 10527 id = 134 }
      name  = "11Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 10527 id = 135 }
      name  = "12Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 10527 id = 171 }
      name  = "13Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 10527 id = 172 }
      name  = "14Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10527 id = 173 }
      name  = "15Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
  }
  navalunit =
  { id       = { type = 10527 id = 174 }
    location = 32
    base     = 32
    name     = "䴬 "
    division =
    { id   = { type = 10527 id = 175 }
      name = "5佢֧ "
      type = transport
    }
    division =
    { id   = { type = 10527 id = 176 }
      name = "6佢֧ "
      type = transport
    }
    division =
    { id   = { type = 10527 id = 177 }
      name = "7佢֧ "
      type = transport
    }
    division =
    { id   = { type = 10527 id = 178 }
      name = "8佢֧ "
      type = transport
    }
    division =
    { id   = { type = 10527 id = 179 }
      name = "9佢֧ "
      type = transport
    }
  }
  # ############################
  # Arme de l'Air 1939 OOB####
  # ############################
  airunit =
  { location = 56
    base     = 56
    id       = { type = 10527 id = 136 }
    name     = "վ "
    division =
    { id       = { type = 10527 id = 137 }
      name     = "21ս "
      type     = interceptor
      model    = 3
      strength = 80
    }
    division =
    { id       = { type = 10527 id = 138 }
      name     = "23ս "
      type     = interceptor
      model    = 0
      strength = 80
    }
    division =
    { id       = { type = 10527 id = 139 }
      name     = "25ս "
      type     = interceptor
      model    = 0
      strength = 40
    }
    division =
    { id       = { type = 10527 id = 140 }
      name     = "1սը "
      type     = tactical_bomber
      model    = 1
      strength = 50
    }
  }
  airunit =
  { location = 62
    base     = 62
    id       = { type = 10527 id = 141 }
    name     = "վ "
    division =
    { id       = { type = 10527 id = 142 }
      name     = "22ս "
      type     = interceptor
      model    = 3
      strength = 80
    }
    division =
    { id       = { type = 10527 id = 143 }
      name     = "3սը "
      type     = tactical_bomber
      model    = 1
      strength = 30
    }
  }
  airunit =
  { location = 364
    base     = 364
    id       = { type = 10527 id = 144 }
    name     = "Ϸվ "
    division =
    { id       = { type = 10527 id = 145 }
      name     = "24ս "
      type     = interceptor
      model    = 0
      strength = 60
    }
  }
  airunit =
  { location = 528
    base     = 528
    id       = { type = 10527 id = 146 }
    name     = "˹վ "
    division =
    { id       = { type = 10527 id = 147 }
      name     = "10ս "
      type     = interceptor
      model    = 0
      strength = 30
    }
  }
  airunit =
  { location = 364
    base     = 364
    id       = { type = 10527 id = 148 }
    name     = "Ͽվ "
    division =
    { id       = { type = 10527 id = 149 }
      name     = "ҹս "
      type     = interceptor
      model    = 0
      strength = 30
    }
    division =
    { id       = { type = 10527 id = 150 }
      name     = "18ը "
      type     = cas
      model    = 0
      strength = 30
    }
    division =
    { id       = { type = 10527 id = 151 }
      name     = "3ը "
      type     = naval_bomber
      model    = 0
      strength = 30
    }
  }
  airunit =
  { location = 939
    base     = 939
    id       = { type = 10527 id = 152 }
    name     = "޿վ "
    division =
    { id       = { type = 10527 id = 153 }
      name     = "1ս "
      type     = interceptor
      model    = 0
      strength = 50
    }
    division =
    { id       = { type = 10527 id = 154 }
      name     = "9սը "
      type     = tactical_bomber
      model    = 0
      strength = 60
    }
  }
  airunit =
  { location = 1794
    base     = 1794
    id       = { type = 10527 id = 155 }
    name     = "жվ "
    division =
    { id       = { type = 10527 id = 156 }
      name     = "2ս "
      type     = interceptor
      model    = 0
      strength = 25
    }
    division =
    { id       = { type = 10527 id = 157 }
      name     = "10սը "
      type     = tactical_bomber
      model    = 0
      strength = 20
    }
  }
  airunit =
  { location = 1337
    base     = 1337
    id       = { type = 10527 id = 158 }
    name     = "ӡ֧ǿվ "
    division =
    { id       = { type = 10527 id = 159 }
      name     = "1ը "
      type     = naval_bomber
      model    = 0
      strength = 30
    }
  }
  airunit =
  { location = 981
    base     = 981
    id       = { type = 10527 id = 160 }
    name     = "ǿվ "
    division =
    { id       = { type = 10527 id = 161 }
      name     = "2ը "
      type     = naval_bomber
      model    = 0
      strength = 20
    }
  }
  division_development =
  { name  = " "
    type  = battleship
    model = 3
    cost  = 8
    id    = { type = 10527 id = 200 }
    date  = { year = 1940 month = july day = 1 }
  }
  division_development =
  { name  = "13֧ "
    type  = destroyer
    model = 2
    cost  = 1.6
    id    = { type = 10528 id = 201 }
    date  = { year = 1939 month = december day = 1 }
  }
}
